/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.target;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.target.CommonTargeting;
import com.ibm.hwmca.fw.target.CommonTargetingTasklet;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetActionListener;
import com.ibm.hwmca.fw.target.TargetRetriever;
import com.ibm.hwmca.fw.target.TaskletTargetActionListener;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.util.LocalizableText;

public final class NextTargetsActionListener
implements TargetActionListener {
    private LocalizableText name = null;
    private TargetRetriever retriever = null;
    private ClassId[] types = null;
    private String nextTaskId = null;
    private int type;
    private boolean multiSelect = false;

    public NextTargetsActionListener(TargetRetriever retriever, LocalizableText name, ClassId[] allowedTypes, String taskid, boolean multiSelect, int type) {
        if (retriever == null) {
            throw new IllegalArgumentException("null target retriever specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("null action name specified");
        }
        this.name = name;
        if (allowedTypes != null) {
            this.types = new ClassId[allowedTypes.length];
            System.arraycopy(allowedTypes, 0, this.types, 0, this.types.length);
        }
        this.retriever = retriever;
        this.nextTaskId = taskid;
        this.type = type;
        this.multiSelect = multiSelect;
    }

    public void performAction(Target[] targets) throws HException {
        this.performNextAction(targets, null);
    }

    boolean performNextAction(Target[] targets, PanelTasklet tasklet) throws HException {
        boolean redisplay = false;
        TargetActionListener action = null;
        do {
            redisplay = false;
            CommonTargeting nextCt = new CommonTargeting(this.retriever, this.nextTaskId, this.multiSelect, this.type, targets);
            nextCt.show(tasklet);
            action = nextCt.getTargetActionListener();
            if (action == null) continue;
            if (action instanceof TaskletTargetActionListener && tasklet instanceof CommonTargetingTasklet) {
                CommonTargetingTasklet ctt = (CommonTargetingTasklet)tasklet;
                TaskletTargetActionListener ttal = (TaskletTargetActionListener)action;
                ttal.performAction(nextCt.getSelectedTargets(), ctt.getCurrentResponse(), tasklet);
                continue;
            }
            if (action instanceof NextTargetsActionListener) {
                boolean actionPerformed = ((NextTargetsActionListener)action).performNextAction(targets, tasklet);
                if (actionPerformed) continue;
                redisplay = true;
                continue;
            }
            nextCt.performAction();
        } while (redisplay);
        return action != null;
    }

    public LocalizableText getActionName() {
        return this.name;
    }

    public TargetActionListener[] getSubActions() {
        return null;
    }

    public ClassId[] getAllowedTypes() {
        return this.types;
    }

    TargetRetriever getTargetRetriever() {
        return this.retriever;
    }
}

